/*
 * @brief Secondary loader main application code
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "chip.h"
#include "sl_common.h"
//#include <string.h>
#include "chip_setup.h"

#if 0
#define LED_BLUE_ON  GPIOSetDir( 0, 11, 1 );\
					GPIOSetBitValue(0, 11, 0);
					
#define LED_BLUE_OFF GPIOSetDir( 0, 11, 1 );\
					GPIOSetBitValue(0, 11, 1);
					
#define LED_RED_ON  GPIOSetDir( 0, 13, 1 );\
					GPIOSetBitValue(0, 13, 0);
					
#define LED_RED_OFF GPIOSetDir( 0, 13, 1 );\
					GPIOSetBitValue(0, 13, 1);
#endif
//--AZ-LPC845
#define LED_BLUE_ON  GPIOSetDir( 1, 15, 1 );\
					GPIOSetBitValue(1, 15, 0);
					
#define LED_BLUE_OFF GPIOSetDir( 1, 15, 1 );\
					GPIOSetBitValue(1, 15, 1);

#define LED_RED_ON  GPIOSetDir( 0, 12, 1 );\
					GPIOSetBitValue(0, 12, 0);
					
#define LED_RED_OFF GPIOSetDir( 0, 12, 1 );\
					GPIOSetBitValue(0, 12, 1);
					
#define LED_GREEN_ON  GPIOSetDir( 0, 0, 1 );\
					GPIOSetBitValue(0, 0, 0);
					
#define LED_GREEN_OFF GPIOSetDir( 0, 0, 1 );\
					GPIOSetBitValue(0, 0, 1);
					
#define SPIBAUD 1000000
#define SCK_PIN P0_24
#define MOSI_PIN P0_25
#define SSEL_PIN P0_21
#define MISO_PIN P0_20//--4
#define CTL_LEN(b)    (((b)-1)<<24)					
					
#if 1			
#define SPI_FLASH_CS1()    (LPC_GPIO_PORT->SET[0] = 1<<P0_16)				/* Use for LPC804 */
#define SPI_FLASH_CS0()    (LPC_GPIO_PORT->CLR[0] = 1<<P0_16)				/* Use for LPC804 */
/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/
extern SPIS_XFER_T spiSlaveXfer;
extern int buffXferPending;

typedef void (*loopHostIfFunc)(int pNum);
loopHostIfFunc loopI2C_pFunc;

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/
 SL_HOSTIF_PACKET_T sendBuff, recvBuff;

IMG_HEADER_T *pImageHeader1 = (IMG_HEADER_T *) (SL_BOOTAPP_ADDR1 + SL_BOOTAPP_IMGHDR_OFS);
IMG_HEADER_T *pImageHeader2 = (IMG_HEADER_T *) (SL_BOOTAPP_ADDR2 + SL_BOOTAPP_IMGHDR_OFS);

static SL_PINSETUP_T *pinCfgData = (SL_PINSETUP_T *) SL_ADDRESS_APPPINDATA;
static uint32_t *pushAppFlag = (uint32_t *) SL_ADDRESS_APPCALLEDFL;

uint32_t *FW_VERSION1=(uint32_t *) 0x2114;
uint32_t *FW_VERSION2=(uint32_t *) 0x5114;

uint8_t App_CRC_Flag1=0;
uint8_t App_CRC_Flag2=0;



/*****************************************************************************
 * Private functions
 
 ****************************************************************************/

/* It is recommended to call this function on system boot or transfer to
   the app. */
void CleanUpSystem(void)
{
	/* Disable peripheral clocks for host IF */
	switch (slIfConfig.ifSel) {
	case SL_SPI0:
		shutdownInterfaceSPI(0);
	
	default:
		break;
	}
	
	Chip_GPIO_DeInit();
	Disable_Periph_Clock(CLK_IOCON);
	
	LPC_SYSCON->MAINCLKSEL        = MAINCLKSEL_VAL;     // Update the actual register
	LPC_SYSCON->MAINCLKUEN        = 0;                  // Toggle update register
	LPC_SYSCON->MAINCLKUEN        = 1;
	
}

void SPI_Init(void)
{
#if 0
	//--Yang
  //直接定义SPI0接口
	LPC_SYSCON->SYSAHBCLKCTRL0 |= ( SWM | GPIO | SPI0 | IOCON);
  
	// Provide main_clk as function clock to SPI0
  LPC_SYSCON->SPI0CLKSEL = FCLKSEL_MAIN_CLK;
  // Configure the SWM 
  ConfigSWM(SPI0_SCK,   P0_1);   /* Use for LPC804 */ 
  ConfigSWM(SPI0_MISO,  P0_9);   /* Use for LPC804 */
  ConfigSWM(SPI0_MOSI,  P0_8);   /* Use for LPC804 */ 
	ConfigSWM(SPI0_SSEL0,  P0_16);   /* Use for LPC804 */
	
  //LPC_GPIO_PORT->DIRSET[0] = 1<<P0_16;
	
	LPC_SYSCON->SYSAHBCLKCTRL0 |=  SPI0 ;
	
  // Setup the SPIs ...
  LPC_SYSCON->PRESETCTRL0 &=  (SPI0_RST_N);
  LPC_SYSCON->PRESETCTRL0 |= ~(SPI0_RST_N);
 
  SystemCoreClockUpdate();                // Get main_clk frequency

  // Configure the CFG registers:
  // Enable=false, slave, no LSB first, CPHA=0, CPOL=0, no loop-back, SSEL active low
  LPC_SPI0->CFG = (0 << 2);
 
  setupInterfaceSPI(0);
#endif

//--AZ
	LPC_SYSCON->SYSAHBCLKCTRL[0] |= (SPI0|SWM|GPIO0|GPIO1|IOCON);

  // Configure the SWM----Note these parameter in 'swm.h' ,like '#define SPI0_SCK 15'
  ConfigSWM(SPI0_SCK, SCK_PIN);
  ConfigSWM(SPI0_MOSI, MOSI_PIN);
  ConfigSWM(SPI0_SSEL0, SSEL_PIN);
  ConfigSWM(SPI0_MISO, MISO_PIN);
  // Select main_clk as the function clock source for SPI0
  LPC_SYSCON->SPI0CLKSEL = FCLKSEL_MAIN_CLK;
   // Give SPI0 a reset
  LPC_SYSCON->PRESETCTRL0 &= (SPI0_RST_N);
  LPC_SYSCON->PRESETCTRL0 |= ~(SPI0_RST_N);
  // Configure the CFG register:
  // Enable=true, slave, no LSB first, CPHA=0, CPOL=0, no loop-back, SSEL active low
  LPC_SPI0->CFG = (0 << 0)|(0 << 2);
				//#define CFG_ENABLE			(1 << 0);#define CFG_SLAVE				(0 << 2)
	LPC_SPI0->TXCTRL = CTL_LEN(8);


	setupInterfaceSPI(0);				//--!!SPI0_Set 8 bits and other SPI0 configuration
									
}

Bool boot_App_ImageCheck(uint8_t app_number)
{
	IMG_HEADER_T *pImageHeader;
	Bool boot = FALSE;
	
	if(app_number==1)
		pImageHeader=pImageHeader1;
	else
		pImageHeader=pImageHeader2;
		
	/* check if there is a image header in flash or else don't boot */
	if ((pImageHeader->header_marker == IMG_HEADER_MARKER) &&
		(pinCheckValidHostif(&pImageHeader->hostifPinCfg) != FALSE)) {	/* Check if a valid ping config information is programmed in the image header */

			//imag_type==0---Normal image check IRQ line to halt boot
		switch (pImageHeader->hostifPinCfg.img_type) {
		case IMG_AP_WAIT:
			/* goto secondary boot loader and wait for AP BOOT command */
			boot = FALSE;
			break;

		default:
		case IMG_NO_CRC:
		case IMG_NORMAL:
			/* check if host wants us to bypass boot due to bad image */
			/* check host requesting us to halt boot through IRQ line (pulled low after reset) */

//		    GPIOSetDir(PINCFG_GET_PORT(pImageHeader->hostifPinCfg.hostIrqPortPin), PINCFG_GET_PIN(pImageHeader->hostifPinCfg.hostIrqPortPin),0 );		
//		    if(GPIOGetPinValue( PINCFG_GET_PORT(pImageHeader->hostifPinCfg.hostIrqPortPin),PINCFG_GET_PIN(pImageHeader->hostifPinCfg.hostIrqPortPin)) == false) {
			GPIOSetDir(0, 14,0 );			//--AZ did
			if(GPIOGetPinValue(0,14) == false) { //--AZ did

				/* go to secondary boot loader */
				boot = FALSE;
				break;
			}
			/* skip CRC check if image type is IMG_NO_CRC */
			if (pImageHeader->hostifPinCfg.img_type == IMG_NO_CRC) {
				/* no more checks just boot */
				boot = TRUE;
				break;
			}

		case IMG_NO_WAIT:
			/* Perform a CRC check of the FLASH where the application is located. Jump
			   to it if it is valid, but only if this wasn't called from the
			   application. */
			if (checkAppCRC(app_number) == 0) {
				/* Valid application exists in application FLASH, so it's ok to boot the
				   application. */				
				boot = TRUE;
			}

			break;

		}
	}
	return boot;

}

void boot_ImageCheck(void)
{

	/*If IRQ pin is pulled low by host, skip app CRC check and don't boot app.*/
	App_CRC_Flag1=boot_App_ImageCheck(1);
//	App_CRC_Flag2=boot_App_ImageCheck(2);
	
	if(App_CRC_Flag1==TRUE)
	{
			doCleanBoot(SL_BOOTAPP_ADDR1);
	}
}
#if 0
void boot_ImageCheck(void)
{

	/*If IRQ pin is pulled low by host, skip app CRC check and don't boot app.*/
	App_CRC_Flag1=boot_App_ImageCheck(1);
	App_CRC_Flag2=boot_App_ImageCheck(2);
	
	if(App_CRC_Flag1==TRUE && App_CRC_Flag2==TRUE)
	{
		if(*FW_VERSION1>=*FW_VERSION2)
			doCleanBoot(SL_BOOTAPP_ADDR1);
		else
			doCleanBoot(SL_BOOTAPP_ADDR2);
	}
	else if(App_CRC_Flag1==TRUE)
		doCleanBoot(SL_BOOTAPP_ADDR1);
	else if(App_CRC_Flag2==TRUE)
		doCleanBoot(SL_BOOTAPP_ADDR2);
}
#endif
/*****************************************************************************
 * Public functions
 ****************************************************************************/

 void doCleanBoot(uint32_t appBootAddr)
{
	/* Cleanup before going to app */
	CleanUpSystem();

	bootValidApp(appBootAddr);
	/***** Control should never come here *****/

}

static uint8_t isbootFromReset(void)
{
	/* Was loader booted from app (1) or from FLASH on reset (0x44)? */
	if((uint8_t)*pushAppFlag == 0x44){
		return 1;
	}

	return 0;
}
#endif


//--Adision own SPI
#if 0


unsigned char rx_buffer;
int handshake=0;
//
// SPI1 interrupt service routine. Reads one received char from the RXDAT register, stores it in the rx_buffer.
//
void SPI0_IRQHandler() {
  LPC_SYSCON->SYSAHBCLKCTRL0 |= GPIO;       // Turn GPIO clock back on for the LEDs
  rx_buffer = LPC_SPI0->RXDAT;              // Get the current character, store it for main
  handshake = true;                         // Set handshake for main()
  LED_RED_OFF;
	return;
}
//
// main routine
//
int main(void) {

  int k;
  uint32_t * addr = (uint32_t *)LPC_IOCON_BASE;

  // Enable clocks to relevant peripherals
  LPC_SYSCON->SYSAHBCLKCTRL[0] |= (SPI0|SWM|GPIO0|GPIO1|IOCON);

  // Configure the SWM
  ConfigSWM(SPI0_SCK, SCK_PIN);
  ConfigSWM(SPI0_MOSI, MOSI_PIN);
  ConfigSWM(SPI0_SSEL0, SSEL_PIN);

  // Select main_clk as the function clock source for SPI0
  LPC_SYSCON->SPI0CLKSEL = FCLKSEL_MAIN_CLK;

   // Give SPI0 a reset
  LPC_SYSCON->PRESETCTRL0 &= (SPI0_RST_N);
  LPC_SYSCON->PRESETCTRL0 |= ~(SPI0_RST_N);

  // Configure the CFG register:
  // Enable=true, slave, no LSB first, CPHA=0, CPOL=0, no loop-back, SSEL active low
  LPC_SPI0->CFG = (1 << 0)|(0 << 2);
				//#define CFG_ENABLE			(1 << 0);#define CFG_SLAVE				(0 << 2)
  // Configure the SPI control register
  // Slave: LEN 8 bits.
//  LPC_SPI0->TXCTL = CTL_LEN(8);
	LPC_SPI0->TXCTRL = CTL_LEN(8);

  // Write dummy data to slave TXDAT
  LPC_SPI0->TXDAT = 0xAA;

  // Enable SPI0 interrupt as wake-up interrupt in SYSCON
//  LPC_SYSCON->STARTERP1 = SPI0_INT_WAKEUP;

  // Enable SPI0 interrupt on received data
  LPC_SPI0->INTENSET = (1<<0);
		//--#define RXRDYEN             (1<<0)
  NVIC_EnableIRQ(SPI0_IRQn);

	LED_BLUE_ON;
	LED_RED_ON;
	LED_GREEN_ON;
  while(1) {

  } // end of while(1)

} // end of main
#endif

#if 1
//--Yang
/**
 * @brief	main routine for Secondary loader
 * @return	Function should not exit
 */

int main(void)
{
	IRQn_Type irqNum;
  loopHostIfFunc loopHostIf;	
	int pNum;
	

	Enable_Periph_Clock(CLK_SWM);
	Enable_Periph_Clock(CLK_IOCON);
	
	GPIOInit();								//--Clock and Reset
	LED_BLUE_OFF;
//--detemine SBL OR application.(if ignore these code=SBL;if not ignore,excute application)	
	/*if boot is from reset, check is there valid app? If app is valid, then boot app.*/
	if (isbootFromReset()) {	          
		/*If IRQ pin is pulled low by host, skip app CRC check and don't boot app.*/
		boot_ImageCheck();
	}
	
	/* Disable sysTick */
	SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;

	/* Disable all NVIC interrupts in case this loader is called from the user application */	   
	for (irqNum = SPI0_IRQn; irqNum <= PININT7_IRQn; irqNum++) {
		NVIC_DisableIRQ(irqNum);
	}

	/* Enable core interrupts */
	__enable_irq();

	/* Update core clock variable, main_clk = fro_clk = 30M */
	SystemCoreClockUpdate();

	/* Initialize host interface , configure IRQ pin*/
	Hostif_Init();//--P0_14

  SPI_Init();
	
	/*Set IRQ Pin as OUTPUT*/
	GPIOSetDir( slIfConfig.hostIrqPortPin.port, slIfConfig.hostIrqPortPin.pin, 1 );

	//Pull IRQ high
  Hostif_DeAssertIRQ();

	LED_BLUE_ON;
	
  /*Initialize spiSlaveXfer structure and preload data to response SPI master */
	startHostIfSPI();						//--??--Preload data to TXDATA to response master
	loopHostIf = &loopHostIfSPI;//-- <1.1 (sl_hostif_spi.h)just statement>SPI host interface processing loop
	slIfConfig.pSPI = LPC_SPI0;


	/********************************************************/
	/****** Start of main host interface handling */
	/********************************************************/

	/* Wait for packets from the host, process the packet, and then respond to the host */
	while (1) {
		
		loopHostIf(pNum);				 //-- <1.2 execute>

		/* Is packet pending? */
		if (hostIfPacketPending() == true) {
			buffXferPending=0;
			/* Send packet to parser and get new packet */			//--!!!Flash
			processHostIfPacket(&recvBuff, &sendBuff);

			/* Handle response, waiting for the rising edge of SPI CS */
			while (hostIfPacketPending() != true) {
				loopHostIf(pNum);
			}
		}
	}

	/********************************************************/
	/****** End of main host interface handling */
	/********************************************************/

	/* Never called */
	return 0;
}
#endif







